// Remote PWM Controler 
// main.c
// 2008 admin@stillberg.com
// PIC16F690
// HI-TECH C Lite
#include <htc.h>
#include "lcd.h"
#include "delay.h"
// _IESO_OFF 0x3BFF
// _FCMEN_OFF 0x37FF
__CONFIG(INTIO & WDTDIS & PWRTDIS & MCLRDIS & BORDIS & 0x3BFF & 0x37FF);

#define BTN_UP	RA1
#define BTN_DN	RA2
#define BTN_RT	RA3
#define BTN_LT	RA4
#define BTN_ST	RA5

#define LED	RC0

#define FR	RC4

#define PR2VALUE 199
#define MAXDUTY	 200
#define DUTYUNIT 2
#define MINDUTY  20
#define P30DUTY  80
#define P60DUTY  60
#define FORCEDUTY	80
#define T2PRESCALE	0b10	// 16

unsigned long count122 = 0;	// about 1/122 second count by prescale 32
unsigned char fFR = 0;
unsigned char uDuty = 0;
unsigned char uLastDuty = 0;
unsigned char fAuto = 0;
unsigned char fForce = 0;
unsigned char fUP = 0;
unsigned char fDN = 0;
unsigned char fRT = 0;
unsigned char fLT = 0;
unsigned char fST = 0;
unsigned long UPcount;
unsigned long DNcount;
unsigned long RTcount;
unsigned long LTcount;
unsigned long STcount;
unsigned long Autocount;
unsigned long ADCcount;

// service routine for timer 0 interrupt 
void interrupt timer0_isr(void){
	count122++;
	T0IF = 0;
}

void showFR(void) {
		lcd_goto(0x03);
		lcd_putch(fFR ? 0x7e : 0x7f);
}

void setFR(unsigned fr) {
	if( fr == 3 ) {
		fr = fFR ? 0 : 1;
	}
	if( fr != fFR ) {
		fFR = fr;
		FR = fr;
		showFR();
	}
} 

void itoa(char *buf, int len, unsigned val){
	int pos, v0;
	for( pos = 0; pos < len; pos++ ) {
		*(buf + pos) = ' ';
	}
	*(buf + len) = 0;
	if( val ) {
		for( pos = len - 1; pos >= 0 && val > 0; pos-- ) {
			v0 = val % 10;
			*(buf + pos) = '0' + v0;
			val = val / 10;
		}
	} else {
		*(buf + len - 1) = '0';
	}
}

void showDuty(void) {
	char buf[5];
	unsigned pct;
	pct = uDuty * 100 / MAXDUTY;
	itoa(buf, 3, pct);
	lcd_goto(0x05);
	lcd_puts(buf);
	lcd_puts("%");
}

void setDuty(unsigned char duty) {
	uDuty = duty;
	CCPR1L = uDuty;
	showDuty();
}	

void fullDuty(void) {
	if( uDuty < MAXDUTY ) {
		setDuty(MAXDUTY);		
	}
}

void zeroDuty(void) {
	if( uDuty > 0 ) {
		setDuty(0);		
	}
}

void incDuty(void) {
	if( uDuty <= MAXDUTY - DUTYUNIT ) {
		setDuty(uDuty + (uDuty ? DUTYUNIT : MINDUTY));
	}
}

void decDuty(void) {
	if( uDuty > MINDUTY  ) {
		setDuty(uDuty - DUTYUNIT);
	} else {
		zeroDuty();
	}
}

unsigned long autoperiod(void) {
	if( uDuty >= P30DUTY ) {
		return 30;
	} else if( uDuty >= P60DUTY ) {
		return 30 + (unsigned long)(P30DUTY - uDuty) * 30 / (P30DUTY - P60DUTY);
	} else {
		return 60;
	}
}

unsigned char readADC0(void) {
	GODONE = 1;	// initiate conversion on the selected channel
	while(GODONE)continue;
	return(ADRESH);	// return 8 MSB of the result
}

void showCurrent(void) {
	unsigned cur;
	char buf[4];
	cur = (unsigned)readADC0() * 250 / 256 * 4;
	itoa(buf, 3, cur);
	lcd_goto(0x40);
	lcd_puts(buf);
	lcd_puts("mA");
}	

void chkbtn(void) {
	if( fAuto || BTN_UP || BTN_DN || BTN_LT || BTN_RT || BTN_ST ) {
		LED = 1;
	} else {
		LED = 0;
	}
	if( BTN_LT ) {
		if( fLT ) {
			if( !fForce && uDuty == 0 && count122 > LTcount + 60 ) {
				setFR(0);
				setDuty(uLastDuty ? uLastDuty : FORCEDUTY);
				fForce = 1;
			} 
		} else {
			fLT = 1;
			LTcount = count122;
		}
	} else if( fLT ) {
		if( fForce ) {
			zeroDuty();
			fForce = 0;
		} else if( !fAuto ) {
			if( uDuty && fFR == 1 ) {
				uLastDuty = uDuty;
				fAuto = 3;	// Auto reverse
			} else {
				setFR(0);
			}
		}
		fLT = 0;
	}
	if( BTN_RT ) {
		if( fRT ) {
			if( !fForce && uDuty == 0 && count122 > RTcount + 60 ) {
				setFR(1);
				setDuty(uLastDuty ? uLastDuty : FORCEDUTY);
				fForce = 1;
			}
		} else {
			fRT = 1;
			RTcount = count122;
		}
	} else if( fRT ) {
		if( fForce ) {
			zeroDuty();
			fForce = 0;
		} else if( !fAuto ) {
			if( uDuty && fFR == 0 ) {
				uLastDuty = uDuty;
				fAuto = 3;	// Auto reverse
			} else {
				setFR(1);
			}
		}
		fRT = 0;
	}
	if( BTN_UP ) {
		if( fUP ) {
			if( count122 > UPcount + (fUP == 1 ? 60 : 20) ) {
				incDuty();
				fUP = 2;
				UPcount = count122;
			}
		} else {
			fUP = 1;
			UPcount = count122;
		}
	} else {
		if( fUP == 1 ) {
			incDuty();
		}
		fUP = 0;
	}
	if( BTN_DN ) {
		if( fDN ) {
			if( count122 > DNcount + (fDN == 1 ? 60 : 20) ) {
				decDuty();
				fDN = 2;
				DNcount = count122;
			}
		} else {
			fDN = 1;
			DNcount = count122;
		}
	} else {
		if( fDN == 1 ) {
			decDuty();
		}
		fDN = 0;
	}
	if( BTN_ST ) {
		if( fST ) {
			if( count122 > STcount + 60 ) {
				if( uDuty && !fAuto && !fForce ) {
					uLastDuty = uDuty;
				}
				zeroDuty();
				fST = 2;
				fAuto = 0;
				STcount = count122;
			}
		} else {
			fST = 1;
			STcount = count122;
		}
	} else {
		if( fST == 1 ) {
			if( fAuto ) {
				fAuto = 0;
			} else {
				Autocount = count122;
				if( uDuty ) {
					uLastDuty = uDuty;
					fAuto = 1;	// Auto stop
				} else {
					fAuto = 2;	// Auto start
				}
			}
		}
		fST = 0;
	}
	if( fAuto == 1 || fAuto == 3 ) { // Auto stop or reverse
		if( count122 > Autocount + autoperiod() ) {
			decDuty();
			Autocount = count122;
			if( uDuty == 0 ) {
				if( fAuto == 1 ) {
					fAuto = 0;
				} else {
					setFR(3);
					fAuto = 2;
				}
			}
		}
	} else if( fAuto == 2 ) {	// Auto start
		if( count122 > Autocount + autoperiod() ) {
			incDuty();
			Autocount = count122;
			if( uDuty >= uLastDuty ) {
				fAuto = 0;
			}
		}
	}	 
	if( count122 > ADCcount + 20 ) {
		showCurrent();
		ADCcount = count122;
	}
}

void main(void)
{
	OPTION = 0b0100;	// prescale by 32
	T0CS = 0;			// select internal clock
	T0IE = 1;			// enable timer interrupt
	GIE = 1;			// enable global interrupts
	
	TRISC = 0x00;	// output mode

	TRISA = 0xFF;	// input mode
	WPUA = 0x00;	// NO week pull up for port A
	ANSEL = 0x01;	// digital mode without RA0
	ADCON0 = 0;		// select left justify result. AN0(RA0)
	ADCON1 = 0b00100000;	// select Fosc/32
	ADIE = 0;		// AD interrupt off
	ADON = 1;		// turn on the A2D conversion module
	DelayMs(1);
	ADCcount = count122;

	// PWM setting
	TRISC5 = 1;		// CCP1 output off
	PR2 = PR2VALUE;		// 
	CCP1CON = 0b00001100;	// single PWM mode
	CCPR1L = 0;	// zero duty
	T2CON = 0b00000100 | T2PRESCALE;	// Timer 2 ON 
	while( !TMR2IF ) {}	// wait Timer 2 cycle 
	TRISC5 = 0;		// CCP1 output on

	lcd_init();
	lcd_goto(0);
	lcd_puts("OK");
		
	zeroDuty();
	showDuty();
	setFR(1);
	setFR(0);
	showFR();
	
	while (1){
		chkbtn();	
	}
}
